@Echo off
Rem Autor:	Stefan Hasensperling
Rem Version:	1.0 24.06.2015
Rem			Initial Version

echo.
echo ------------------------------------------------------------------------
echo BatchXpert Backup Creator for Automatic Database Refresh
echo MLogics Chile Ltda.
echo Copyright  MLogics Chile Ltda 2015 
echo. 
echo Backup will be put into:
echo C:\Transfer\%computername%\
echo ------------------------------------------------------------------------
echo.

Rem ################################################################################################################################################################
Rem Checking Command line Parameters and set default values
Rem ------------------------------------------------------------------------
pushd "%~dp0%"
SET Visu=%1
SET BC=%2
SET MAT=%3

if [%1] == [] 	SET Visu="D:\Kunstmann\Visu\BatchXpert\"
if [%2] == [] 	SET BC=Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=BatchConfig;Data Source=.\GRAPHPIC
if [%3] == []	SET MAT=Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=Material;Data Source=.\GRAPHPIC

Rem ################################################################################################################################################################
echo Start Database Backup
echo ------------------------------------------------------------------------
"C:\Program Files (x86)\BatchXpert\BatchXpert DB Administration Tool.exe" -b -silent -s="%BC%" -f="C:\Daten\Backup\BatchConfig.bak"
IF ERRORLEVEL 1 GOTO Err1
xcopy /y "C:\Daten\Backup\BatchConfig.bak" "C:\Transfer\%computername%\"
IF ERRORLEVEL 1 GOTO Err1

"C:\Program Files (x86)\BatchXpert\BatchXpert DB Administration Tool.exe" -b -silent -s="%MAT%" -f="C:\Daten\Backup\MaterialConfig.bak"
IF ERRORLEVEL 1 GOTO Err2
xcopy /y /i "C:\Daten\Backup\MaterialConfig.bak" "C:\Transfer\%computername%\"
IF ERRORLEVEL 1 GOTO Err2

Rem ################################################################################################################################################################
echo Start Report Backup
echo ------------------------------------------------------------------------
xcopy  /y /i /s "D:\Kunstmann\Reports" "C:\Transfer\%computername%\Reports\"
IF ERRORLEVEL 1 GOTO Err3

Rem ################################################################################################################################################################
echo Start User Adminstration Backup
echo ------------------------------------------------------------------------
xcopy  /y /i "%Visu%GpUsers.XML" "C:\Transfer\%computername%\"
IF ERRORLEVEL 1 GOTO Err4

Rem ################################################################################################################################################################
echo Backup Successful
echo ------------------------------------------------------------------------
:OK

color 02

call ShowMessageBox "The Backup was successfully Created"
EXIT

Rem ################################################################################################################################################################
echo BatchConfig Copy Failed
echo ------------------------------------------------------------------------
:Err1

color 04
call ShowErrorBox "Error during creating Backup of BatchConfig"
EXIT

Rem ################################################################################################################################################################
echo Material Copy Failed
echo ------------------------------------------------------------------------
:Err2

color 04
call ShowErrorBox "Error during creating Backup of Material"
EXIT

Rem ################################################################################################################################################################
echo Report Copy Failed
echo ------------------------------------------------------------------------
:Err3

color 04
call ShowErrorBox "Error during creating Backup of Reports"
EXIT

Rem ################################################################################################################################################################
echo User Password Copy Failed
echo ------------------------------------------------------------------------
:Err4

color 04
call ShowErrorBox "Error during copying of User Passwords"
EXIT
